﻿using System;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.GetPersonIdentifiers
{
    /// <summary>
    /// Map Corresponding Ids Response to Get Person Identifiers Response step.
    /// </summary>
    public class MapCorrespondingIdsResponseToGetPersonIdentifiersResponseStep : FilterBase<GetPersonIdentifiersStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetPersonIdentifiersStateObject state)
        {
            state.GetPersonIdentifiersResponseMessage = new Messages.Mvi.GetPersonIdentifiersResponseMessage
            {
                DateofBirth = state.CorrespondingIdsResponse?.DateofBirth ?? state.DateOfBirth,
                FullAddress = state.CorrespondingIdsResponse?.FullAddress ?? state.FullAddress,
                Edipi = state.CorrespondingIdsResponse?.Edipi ?? state.Edipi,
                ExceptionMessage = state.CorrespondingIdsResponse?.RawMviExceptionMessage,
                ExceptionOccured = state.CorrespondingIdsResponse?.ExceptionOccured ?? false,
                FamilyName = state.CorrespondingIdsResponse?.FamilyName ?? state.FamilyName,
                FetchMessageProcessType = (Messages.Mvi.MessageProcessType)(int) (state.CorrespondingIdsResponse?.FetchMessageProcessType ?? MessageProcessType.Local),
                FirstName = state.CorrespondingIdsResponse?.FirstName ?? state.FirstName,
                FullName = state.CorrespondingIdsResponse?.FullName ?? state.FullName,
                MiddleName = state.CorrespondingIdsResponse?.MiddleName ?? state.MiddleName,
                MessageId = state.CorrespondingIdsResponse?.MessageId,
                ParticipantId = state.CorrespondingIdsResponse?.ParticipantId,
                Ss = state.CorrespondingIdsResponse?.SocialSecurityNumber,
                UserId = state.CorrespondingIdsResponse?.UserId ?? state.UserId,
                Url = string.Format("https://{0}/main.aspx?etn=contact&pagetype=entityrecord&id=%7B{1}%7D", state.ServerName.Substring(state.ServerName.IndexOf("//", StringComparison.Ordinal)+2), state.Contact.ContactId),
                CorrespondingIdList = state.CorrespondingIds,
                ContactId = state.Contact.Id
            };
        }
    }
}